

<?php $__env->startSection('title', 'Login · FamilyTree'); ?>
<?php $__env->startSection('page-title', 'Sign in'); ?>

<?php $__env->startSection('content'); ?>
    <section class="max-w-md mx-auto">
        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-8">
            <?php if($errors->any()): ?>
                <div class="mb-4 text-sm text-rose-700 bg-rose-50 border border-rose-200 rounded-xl p-3">
                    <?php echo e($errors->first()); ?>

                </div>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('login.store')); ?>" class="space-y-5">
                <?php echo csrf_field(); ?>
                <div>
                    <label for="email" class="block text-sm text-slate-600 mb-1">Email</label>
                    <input id="email" name="email" type="email" value="<?php echo e(old('email')); ?>" required autofocus
                           class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" />
                </div>
                <div>
                    <label for="password" class="block text-sm text-slate-600 mb-1">Password</label>
                    <input id="password" name="password" type="password" required
                           class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" />
                </div>
                <label class="flex items-center gap-2 text-sm text-slate-600">
                    <input type="checkbox" name="remember" class="rounded border-slate-300 text-primary focus:ring-primary" />
                    Remember me
                </label>
                <button type="submit" class="w-full inline-flex items-center justify-center gap-2 bg-primary text-white px-4 py-2.5 rounded-xl">
                    <span class="material-symbols-rounded">login</span>
                    Sign in
                </button>
            </form>

            <p class="mt-6 text-center text-sm text-slate-500">
                Don't have an account?
                <a href="<?php echo e(route('register')); ?>" class="text-primary hover:underline">Create one</a>
            </p>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('head'); ?>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@24,400,0,0" />
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\familytree\api\resources\views/auth/login.blade.php ENDPATH**/ ?>