

<?php $__env->startSection('title', 'Family Announcements · FamilyTree'); ?>
<?php $__env->startSection('page-title', 'Family Announcements'); ?>

<?php $__env->startSection('content'); ?>
<section class="space-y-6">
    <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
        <div class="flex flex-wrap items-center justify-between gap-3">
            <div>
                <h2 class="text-base font-semibold text-slate-800"><?php echo e($family->name); ?></h2>
                <p class="text-xs text-slate-500">Send messages to specific members or the whole family</p>
            </div>
            <div class="flex items-center gap-2">
                <a href="<?php echo e(route('families.index')); ?>" class="inline-flex items-center gap-1 text-sm bg-slate-100 text-slate-700 px-3 py-2 rounded-xl hover:bg-slate-200">
                    <span class="material-symbols-rounded text-base">chevron_left</span>
                    Back to directory
                </a>
                <a href="<?php echo e(route('families.tree', $family)); ?>" class="inline-flex items-center gap-1 text-sm bg-slate-100 text-slate-700 px-3 py-2 rounded-xl hover:bg-slate-200">
                    <span class="material-symbols-rounded text-base">account_tree</span>
                    Tree
                </a>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <h3 class="text-sm font-semibold text-slate-700 mb-3">Recent announcements</h3>
            <div class="space-y-3">
                <?php $__empty_1 = true; $__currentLoopData = $announcements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <article class="rounded-xl border border-slate-200 p-4">
                        <h4 class="text-sm font-semibold text-slate-800"><?php echo e($a->title); ?></h4>
                        <p class="text-xs text-slate-500"><?php echo e(optional($a->created_at)->diffForHumans()); ?></p>
                        <p class="mt-2 text-sm text-slate-700"><?php echo e($a->content); ?></p>
                        <p class="mt-2 text-xs text-slate-500">
                            <?php if($a->send_to_all): ?>
                                Sent to: All members
                            <?php else: ?>
                                Sent to:
                                <?php if($a->recipients->isEmpty()): ?>
                                    —
                                <?php else: ?>
                                    <?php echo e($a->recipients->pluck('first_name')->map(fn($n) => trim($n))->implode(', ')); ?>

                                <?php endif; ?>
                            <?php endif; ?>
                        </p>
                    </article>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-sm text-slate-500">No announcements yet.</p>
                <?php endif; ?>
            </div>
            <div class="mt-4">
                <?php echo e($announcements->withQueryString()->links()); ?>

            </div>
        </div>

        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <h3 class="text-sm font-semibold text-slate-700 mb-3">Create announcement</h3>
            <form method="POST" action="<?php echo e(route('families.announcements.store', $family)); ?>" class="space-y-4">
                <?php echo csrf_field(); ?>
                <div>
                    <label class="block text-sm text-slate-600 mb-1">Title</label>
                    <input name="title" required type="text" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" placeholder="Announcement title">
                </div>
                <div>
                    <label class="block text-sm text-slate-600 mb-1">Message</label>
                    <textarea name="content" rows="4" required class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" placeholder="Write your message..."></textarea>
                </div>
                <div class="flex items-center gap-2">
                    <input id="sendAllToggle" name="send_to_all" type="checkbox" value="1" class="rounded border-slate-300 text-primary focus:ring-primary">
                    <label for="sendAllToggle" class="text-sm text-slate-700">Send to all family members</label>
                </div>
                <div>
                    <label class="block text-sm text-slate-600 mb-1">Select recipients (optional)</label>
                    <select id="recipientsSelect" name="recipients[]" multiple class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary h-40">
                        <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($m['id']); ?>"><?php echo e($m['name']); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <p class="mt-1 text-xs text-slate-500">If "Send to all" is checked, the selection above is ignored.</p>
                </div>
                <div>
                    <button type="submit" class="inline-flex items-center gap-2 bg-primary text-white px-4 py-2 rounded-xl">
                        <span class="material-symbols-rounded">send</span>
                        Send announcement
                    </button>
                </div>
            </form>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('head'); ?>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@24,400,0,0" />
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function(){
        var allToggle = document.getElementById('sendAllToggle');
        var recipients = document.getElementById('recipientsSelect');
        function updateDisabled(){
            if (!allToggle || !recipients) return;
            var on = allToggle.checked;
            recipients.disabled = on;
            recipients.classList.toggle('opacity-60', on);
        }
        if (allToggle) {
            allToggle.addEventListener('change', updateDisabled);
            updateDisabled();
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\familytree\api\resources\views/families/announcements/index.blade.php ENDPATH**/ ?>