

<?php $__env->startSection('title', 'Family Events · FamilyTree'); ?>
<?php $__env->startSection('page-title', 'Family Events'); ?>

<?php $__env->startSection('content'); ?>
<section class="space-y-6">
    <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
        <div class="flex flex-wrap items-center justify-between gap-3">
            <div>
                <h2 class="text-base font-semibold text-slate-800"><?php echo e($family->name); ?></h2>
                <p class="text-xs text-slate-500">Upcoming events for this family</p>
            </div>
            <div class="flex items-center gap-2">
                <a href="<?php echo e(route('families.index')); ?>" class="inline-flex items-center gap-1 text-sm bg-slate-100 text-slate-700 px-3 py-2 rounded-xl hover:bg-slate-200">
                    <span class="material-symbols-rounded text-base">chevron_left</span>
                    Back to directory
                </a>
                <a href="<?php echo e(route('families.tree', $family)); ?>" class="inline-flex items-center gap-1 text-sm bg-slate-100 text-slate-700 px-3 py-2 rounded-xl hover:bg-slate-200">
                    <span class="material-symbols-rounded text-base">account_tree</span>
                    Tree
                </a>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <h3 class="text-sm font-semibold text-slate-700 mb-3">Upcoming events</h3>
            <div class="space-y-3">
                <?php $__empty_1 = true; $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <article class="rounded-xl border border-slate-200 p-4">
                        <h4 class="text-sm font-semibold text-slate-800"><?php echo e($event->title); ?></h4>
                        <p class="text-xs text-slate-500">
                            <?php echo e(optional($event->starts_at)->format('M d, Y H:i')); ?>

                            <?php if($event->ends_at): ?>
                                – <?php echo e(optional($event->ends_at)->format('M d, Y H:i')); ?>

                            <?php endif; ?>
                            <?php if($event->location): ?>
                                · <?php echo e($event->location); ?>

                            <?php endif; ?>
                        </p>
                        <?php if($event->description): ?>
                            <p class="mt-2 text-sm text-slate-600"><?php echo e($event->description); ?></p>
                        <?php endif; ?>
                        <?php if(!empty($canManage)): ?>
                            <div class="mt-3 flex items-center gap-2">
                                <a href="<?php echo e(route('families.events.index', [$family->id, 'edit' => $event->id])); ?>" class="text-xs text-primary">Edit</a>
                                <form method="POST" action="<?php echo e(route('families.events.destroy', [$family->id, $event->id])); ?>" onsubmit="return confirm('Delete this event?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="text-xs text-red-600">Delete</button>
                                </form>
                            </div>
                        <?php endif; ?>
                    </article>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-sm text-slate-500">No events yet.</p>
                <?php endif; ?>
            </div>
        </div>

        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <h3 class="text-sm font-semibold text-slate-700 mb-3"><?php echo e(!empty($prefill) ? 'Edit event' : 'Create event'); ?></h3>
            <form method="POST" action="<?php echo e(!empty($prefill) ? route('families.events.update', [$family, $prefill['id']]) : route('families.events.store', $family)); ?>" class="space-y-4">
                <?php echo csrf_field(); ?>
                <?php if(!empty($prefill)): ?>
                    <?php echo method_field('PUT'); ?>
                <?php endif; ?>
                <div>
                    <label class="block text-sm text-slate-600 mb-1">Title</label>
                    <input name="title" value="<?php echo e(old('title', $prefill['title'] ?? '')); ?>" required type="text" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" placeholder="Event title">
                </div>
                <div>
                    <label class="block text-sm text-slate-600 mb-1">Description</label>
                    <textarea name="description" rows="3" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" placeholder="Short description"><?php echo e(old('description', $prefill['description'] ?? '')); ?></textarea>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm text-slate-600 mb-1">Starts at</label>
                        <input name="starts_at" value="<?php echo e(old('starts_at', $prefill['starts_at'] ?? '')); ?>" required type="datetime-local" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary">
                    </div>
                    <div>
                        <label class="block text-sm text-slate-600 mb-1">Ends at</label>
                        <input name="ends_at" value="<?php echo e(old('ends_at', $prefill['ends_at'] ?? '')); ?>" type="datetime-local" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary">
                    </div>
                </div>
                <div>
                    <label class="block text-sm text-slate-600 mb-1">Location</label>
                    <input name="location" value="<?php echo e(old('location', $prefill['location'] ?? '')); ?>" type="text" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" placeholder="Optional location">
                </div>
                <div>
                    <button type="submit" class="inline-flex items-center gap-2 bg-primary text-white px-4 py-2 rounded-xl">
                        <span class="material-symbols-rounded">event</span>
                        <?php echo e(!empty($prefill) ? 'Save changes' : 'Add event'); ?>

                    </button>
                </div>
            </form>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('head'); ?>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@24,400,0,0" />
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\familytree\api\resources\views/families/events/index.blade.php ENDPATH**/ ?>