@extends('layouts.app')

@section('title', 'Subscriptions · FamilyTree')
@section('page-title', 'Subscriptions Overview')

@section('sidebar-left')
    <div class="glass-card rounded-2xl border border-white/50 shadow-card p-5 space-y-4">
        <div>
            <h2 class="text-sm font-semibold text-slate-500 uppercase tracking-wide">Filters</h2>
            <p class="text-xs text-slate-400 mt-1">Coming soon: filter by plan, status, billing cycle.</p>
        </div>
        <div class="flex items-center gap-3 text-sm text-slate-500">
            <span class="material-symbols-rounded text-primary">autorenew</span>
            <span>Active subscriptions only are counted in cards.</span>
        </div>
        <div class="flex items-center gap-3 text-sm text-slate-500">
            <span class="material-symbols-rounded text-primary">stacked_line_chart</span>
            <span>Trend charts aggregate by calendar month.</span>
        </div>
    </div>

    <div class="glass-card rounded-2xl border border-white/50 shadow-card p-5 space-y-3">
        <h2 class="text-sm font-semibold text-slate-500 uppercase tracking-wide">Plans Snapshot</h2>
        <ul class="space-y-2 text-sm text-slate-600">
            @foreach($planPerformance as $plan)
                <li class="flex flex-col gap-1">
                    <div class="flex items-center justify-between">
                        <span class="font-medium text-slate-700">{{ $plan['name'] }}</span>
                        <span class="text-xs bg-primary/10 text-primary px-2 py-0.5 rounded-full">{{ $plan['interval'] }}</span>
                    </div>
                    <div class="text-xs text-slate-500 flex justify-between">
                        <span>{{ $plan['active_subscriptions'] }} active</span>
                        <span>{{ $plan['price'] }}</span>
                    </div>
                </li>
            @endforeach
        </ul>
    </div>
@endsection

@section('content')
    <section class="space-y-6">
        <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-4 gap-4">
            @foreach($summary as $metric)
                <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6 flex flex-col justify-between">
                    <div class="flex items-center justify-between">
                        <div>
                            <h3 class="text-xs uppercase tracking-wider text-slate-400">{{ $metric['label'] }}</h3>
                            <p class="text-2xl font-semibold text-slate-800 mt-2">{{ $metric['value'] }}</p>
                        </div>
                        <span class="material-symbols-rounded text-primary text-3xl" aria-hidden="true">{{ $metric['icon'] }}</span>
                    </div>
                    <p class="text-xs text-slate-500 mt-4">{{ $metric['delta'] }}</p>
                </div>
            @endforeach
        </div>

        <div class="grid grid-cols-1 xl:grid-cols-2 gap-6">
            <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
                <header class="flex items-center justify-between">
                    <div>
                        <h2 class="text-lg font-semibold text-slate-800">Subscription Signups</h2>
                        <p class="text-sm text-slate-500">New subscriptions created each month</p>
                    </div>
                </header>
                <div class="mt-6 space-y-4">
                    @foreach($subscriptionTrend as $index => $point)
                        <div>
                            <div class="flex items-center justify-between text-sm text-slate-600">
                                <span>{{ $point['label'] }}</span>
                                <span class="font-semibold text-slate-800">{{ $point['value'] }}</span>
                            </div>
                            @php($width = min(100, max(6, $point['value'] * 5)))
                            <div class="mt-2 h-2 rounded-full bg-slate-200">
                                <div class="h-2 rounded-full bg-primary transition-all" style="width: {{ $width }}%"></div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
                <header class="flex items-center justify-between">
                    <div>
                        <h2 class="text-lg font-semibold text-slate-800">Revenue Collected</h2>
                        <p class="text-sm text-slate-500">Paid invoices per month (USD)</p>
                    </div>
                </header>
                <div class="mt-6 space-y-4">
                    @foreach($revenueTrend as $point)
                        <div>
                            <div class="flex items-center justify-between text-sm text-slate-600">
                                <span>{{ $point['label'] }}</span>
                                <span class="font-semibold text-slate-800">${{ number_format($point['value'], 2) }}</span>
                            </div>
                            @php($width = min(100, max(6, $point['value'] * 5)))
                            <div class="mt-2 h-2 rounded-full bg-slate-200">
                                <div class="h-2 rounded-full bg-emerald-400 transition-all" style="width: {{ $width }}%"></div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

        <div class="glass-card rounded-2xl border border-white/60 shadow-card">
            <header class="px-6 pt-6 pb-4 flex items-center justify-between">
                <div>
                    <h2 class="text-lg font-semibold text-slate-800">Latest Subscriptions</h2>
                    <p class="text-sm text-slate-500">Recent families coming onboard</p>
                </div>
                <span class="text-xs text-slate-400">Showing {{ $subscriptions->count() }} of {{ $subscriptions->total() }}</span>
            </header>
            <div class="overflow-x-auto">
                <table class="min-w-full text-left text-sm text-slate-600">
                    <thead class="text-xs uppercase text-slate-400 border-y border-slate-200/60">
                        <tr>
                            <th class="px-6 py-3">Family</th>
                            <th class="px-6 py-3">Plan</th>
                            <th class="px-6 py-3">Status</th>
                            <th class="px-6 py-3">Renews</th>
                            <th class="px-6 py-3 text-right">Created</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-200/70">
                        @foreach($subscriptions as $subscription)
                            <tr class="hover:bg-primary/5">
                                <td class="px-6 py-4">
                                    <div class="font-medium text-slate-800">{{ optional($subscription->subscriber)->name ?? '—' }}</div>
                                    <div class="text-xs text-slate-400">ID #{{ $subscription->id }}</div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="font-medium text-slate-700">{{ $subscription->plan?->name ?? 'Unknown' }}</div>
                                    <div class="text-xs text-slate-400">{{ $subscription->plan?->interval ? ucfirst($subscription->plan->interval) : '—' }}</div>
                                </td>
                                <td class="px-6 py-4">
                                    <span @class([
                                        'inline-flex items-center gap-1 px-3 py-1 rounded-full text-xs font-medium',
                                        'bg-emerald-100 text-emerald-700' => in_array($subscription->status, ['active', 'trialing']),
                                        'bg-amber-100 text-amber-700' => $subscription->status === 'pending',
                                        'bg-rose-100 text-rose-700' => $subscription->status === 'canceled',
                                        'bg-slate-200 text-slate-600' => ! in_array($subscription->status, ['active', 'trialing', 'pending', 'canceled']),
                                    ])>
                                        <span class="material-symbols-rounded text-base">circle</span>
                                        {{ ucfirst($subscription->status) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 text-sm text-slate-600">
                                    {{ optional($subscription->renews_at)->format('M j, Y') ?? '—' }}
                                </td>
                                <td class="px-6 py-4 text-sm text-slate-500 text-right">
                                    {{ optional($subscription->created_at)->diffForHumans() ?? '—' }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="px-6 py-4 border-t border-slate-200/60">
                {{ $subscriptions->withQueryString()->onEachSide(1)->links() }}
            </div>
        </div>
    </section>
@endsection

@section('sidebar-right')
    <div class="glass-card rounded-2xl border border-white/50 shadow-card p-6 space-y-4">
        <header>
            <h2 class="text-sm font-semibold text-slate-500 uppercase tracking-wide">Recent Invoices</h2>
            <p class="text-xs text-slate-400">Latest paid or pending invoices</p>
        </header>
        <ul class="space-y-3">
            @foreach($recentInvoices as $invoice)
                <li class="flex justify-between items-start">
                    <div>
                        <p class="text-sm font-medium text-slate-700">{{ $invoice['plan'] }}</p>
                        <p class="text-xs text-slate-400">{{ $invoice['timestamp'] }}</p>
                    </div>
                    <div class="text-right">
                        <span class="text-sm font-semibold text-slate-800">{{ $invoice['amount'] }}</span>
                        <p class="text-xs text-slate-500">{{ $invoice['status'] }}</p>
                    </div>
                </li>
            @endforeach
        </ul>
    </div>

    <div class="glass-card rounded-2xl border border-white/50 shadow-card p-6 space-y-4">
        <header>
            <h2 class="text-sm font-semibold text-slate-500 uppercase tracking-wide">Recent Events</h2>
            <p class="text-xs text-slate-400">Subscription activity log</p>
        </header>
        <ul class="space-y-3">
            @foreach($recentEvents as $event)
                <li class="flex items-start gap-3">
                    <span class="material-symbols-rounded text-primary">history</span>
                    <div>
                        <p class="text-sm font-medium text-slate-700">{{ $event['event'] }}</p>
                        <p class="text-xs text-slate-400">{{ $event['time'] }} • {{ $event['actor'] }}</p>
                    </div>
                </li>
            @endforeach
        </ul>
    </div>
@endsection

@push('head')
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@24,400,0,0" />
@endpush
