@extends('layouts.app')

@section('title', 'Invite Members · FamilyTree')
@section('page-title', 'Invite members to '.$family->name)

@section('content')
    <section class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6 space-y-4">
            <h2 class="text-sm font-semibold text-slate-600 uppercase tracking-wide">Invite via Email or SMS</h2>
            @if(session('status'))
                <div class="rounded-xl bg-emerald-50 text-emerald-700 px-4 py-2 text-sm">{{ session('status') }}</div>
            @endif
            <form method="POST" action="{{ route('families.invite.send', $family) }}" class="space-y-4">
                @csrf
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div>
                        <label for="email" class="block text-sm text-slate-600 mb-1">Email</label>
                        <input id="email" name="email" type="email" value="{{ old('email') }}" placeholder="name@example.com" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" />
                        @error('email')
                            <p class="mt-1 text-xs text-rose-600">{{ $message }}</p>
                        @enderror
                    </div>
                    <div>
                        <label for="phone" class="block text-sm text-slate-600 mb-1">Phone</label>
                        <input id="phone" name="phone" type="text" value="{{ old('phone') }}" placeholder="+233…" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" />
                        @error('phone')
                            <p class="mt-1 text-xs text-rose-600">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
                <p class="text-xs text-slate-400">Provide at least one of Email or Phone.</p>
                <button type="submit" class="inline-flex items-center gap-2 bg-primary text-white px-4 py-2.5 rounded-xl">
                    <span class="material-symbols-rounded text-base">send</span>
                    Send invite
                </button>
            </form>
        </div>

        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6 space-y-4">
            <h2 class="text-sm font-semibold text-slate-600 uppercase tracking-wide">Generate shareable link & QR</h2>
            <form method="POST" action="{{ route('families.invite.send', $family) }}" class="space-y-3">
                @csrf
                <input type="hidden" name="generate" value="1" />
                <p class="text-sm text-slate-600">Creates a tokenized invitation without email/phone. Share the link or QR with relatives.</p>
                <button type="submit" class="inline-flex items-center gap-2 bg-slate-900 text-white px-4 py-2.5 rounded-xl">
                    <span class="material-symbols-rounded text-base">qr_code_2</span>
                    Generate link & QR
                </button>
            </form>
        </div>
    </section>

    <section class="mt-8">
        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-sm font-semibold text-slate-600 uppercase tracking-wide">Recent invitations</h3>
                <a href="{{ route('families.index') }}" class="text-sm text-primary">Back to Families</a>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-5">
                @forelse($invitations as $invitation)
                    @php($acceptUrl = rtrim(config('platform.frontend_url', config('app.url')), '/').'/invitations/accept/'.$invitation->token)
                    <article class="rounded-2xl border border-slate-200/70 p-4 space-y-3">
                        <div class="flex items-start justify-between">
                            <div class="space-y-1">
                                <p class="text-sm font-medium text-slate-800">
                                    {{ $invitation->email ?? ($invitation->phone ?? 'Shareable link') }}
                                </p>
                                <p class="text-xs text-slate-500">Status: <span class="font-medium capitalize">{{ $invitation->status }}</span></p>
                                @if($invitation->expires_at)
                                    <p class="text-xs text-slate-400">Expires {{ $invitation->expires_at->diffForHumans() }}</p>
                                @endif
                            </div>
                            <span class="text-[10px] uppercase tracking-wide rounded-full px-2 py-0.5 {{ $invitation->status === 'accepted' ? 'bg-emerald-50 text-emerald-700' : ($invitation->status === 'revoked' ? 'bg-rose-50 text-rose-700' : 'bg-amber-50 text-amber-700') }}">
                                {{ $invitation->status }}
                            </span>
                        </div>
                        <div class="space-y-2">
                            <a href="{{ $acceptUrl }}" target="_blank" class="text-xs text-primary break-all">{{ $acceptUrl }}</a>
                            <div class="flex items-center gap-2">
                                <button type="button" class="text-xs px-2 py-1 rounded-lg bg-primary/10 text-primary hover:bg-primary/20" data-copy="{{ $acceptUrl }}">Copy link</button>
                            </div>
                        </div>
                        <div class="pt-2">
                            <img src="https://api.qrserver.com/v1/create-qr-code/?size=160x160&data={{ urlencode($acceptUrl) }}" alt="QR code" class="rounded-lg border border-slate-200" loading="lazy">
                        </div>
                    </article>
                @empty
                    <p class="text-sm text-slate-500">No invitations yet. Generate one or send via email/SMS above.</p>
                @endforelse
            </div>
        </div>
    </section>
@endsection

@push('head')
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@24,400,0,0" />
@endpush

@push('scripts')
<script>
    document.addEventListener('click', function(e){
        const btn = e.target.closest('[data-copy]');
        if(!btn) return;
        const text = btn.getAttribute('data-copy');
        navigator.clipboard.writeText(text).then(() => {
            btn.textContent = 'Copied!';
            setTimeout(() => btn.textContent = 'Copy link', 1200);
        });
    });
</script>
@endpush
