<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>{{ $subject ?? 'Notification' }}</title>
    <style>
        body { background: #f6f8fb; font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Roboto, Helvetica, Arial, sans-serif; color: #0f172a; }
        .container { max-width: 640px; margin: 24px auto; background: #ffffff; border-radius: 16px; border: 1px solid #e2e8f0; overflow: hidden; }
        .header { background: linear-gradient(135deg, #0ea5e9, #6366f1); color: #fff; padding: 24px; }
        .header h1 { margin: 0; font-size: 18px; }
        .content { padding: 24px; font-size: 14px; line-height: 1.6; }
        .footer { padding: 16px 24px; color: #64748b; font-size: 12px; background: #f8fafc; }
        .btn { display: inline-block; padding: 10px 16px; border-radius: 10px; background: #0ea5e9; color: #fff; text-decoration: none; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>{{ $appName ?? config('app.name', 'FamilyTree') }}</h1>
        </div>
        <div class="content">
            {!! $content_html ?? '' !!}
        </div>
        <div class="footer">
            <p>You're receiving this because you're a registered user of {{ $appName ?? config('app.name', 'FamilyTree') }}.</p>
            <p>&copy; {{ date('Y') }} {{ $appName ?? config('app.name', 'FamilyTree') }}. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
