@extends('layouts.app')

@section('title', 'Register · FamilyTree')
@section('page-title', 'Create your account')

@section('content')
    <section class="max-w-md mx-auto">
        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-8">
            @if ($errors->any())
                <div class="mb-4 text-sm text-rose-700 bg-rose-50 border border-rose-200 rounded-xl p-3">
                    {{ $errors->first() }}
                </div>
            @endif

            <form method="POST" action="{{ route('register.store') }}" class="space-y-5">
                @csrf
                <div>
                    <label for="name" class="block text-sm text-slate-600 mb-1">Full name</label>
                    <input id="name" name="name" type="text" value="{{ old('name') }}" required
                           class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" />
                </div>
                <div>
                    <label for="email" class="block text-sm text-slate-600 mb-1">Email</label>
                    <input id="email" name="email" type="email" value="{{ old('email') }}" required
                           class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" />
                </div>
                <div>
                    <label for="password" class="block text-sm text-slate-600 mb-1">Password</label>
                    <input id="password" name="password" type="password" required
                           class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" />
                </div>
                <div>
                    <label for="password_confirmation" class="block text-sm text-slate-600 mb-1">Confirm password</label>
                    <input id="password_confirmation" name="password_confirmation" type="password" required
                           class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" />
                </div>
                <button type="submit" class="w-full inline-flex items-center justify-center gap-2 bg-primary text-white px-4 py-2.5 rounded-xl">
                    <span class="material-symbols-rounded">person_add</span>
                    Create account
                </button>
            </form>

            <p class="mt-6 text-center text-sm text-slate-500">
                Already have an account?
                <a href="{{ route('login') }}" class="text-primary hover:underline">Sign in</a>
            </p>
        </div>
    </section>
@endsection

@push('head')
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@24,400,0,0" />
@endpush
