@extends('layouts.app')

@section('title', 'Admin · FamilyTree')
@section('page-title', 'Admin Dashboard')
@section('wide', 'true')

@section('content')
    <section class="space-y-6">
        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
            <h2 class="text-lg font-semibold text-slate-800">Welcome to Admin</h2>
            <p class="text-sm text-slate-600 mt-1">Manage platform configuration and core entities below.</p>
        </div>

        <div class="grid gap-6 md:grid-cols-2 xl:grid-cols-3">
            <a href="{{ route('admin.locations.index') }}" class="block rounded-2xl border border-slate-100 bg-white p-6 hover:shadow-card focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60">
                <div class="text-sm uppercase tracking-widest text-slate-400">Configuration</div>
                <div class="mt-1 text-lg font-semibold text-slate-800">Locations</div>
                <p class="mt-1 text-sm text-slate-600">Countries, regions, districts and towns.</p>
            </a>

            <a href="{{ route('admin.ethnic_groups.index') }}" class="block rounded-2xl border border-slate-100 bg-white p-6 hover:shadow-card focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60">
                <div class="text-sm uppercase tracking-widest text-slate-400">Configuration</div>
                <div class="mt-1 text-lg font-semibold text-slate-800">Ethnic Groups</div>
                <p class="mt-1 text-sm text-slate-600">Manage ethnic groups by country and languages.</p>
            </a>

            <a href="{{ route('admin.clans.index') }}" class="block rounded-2xl border border-slate-100 bg-white p-6 hover:shadow-card focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60">
                <div class="text-sm uppercase tracking-widest text-slate-400">Configuration</div>
                <div class="mt-1 text-lg font-semibold text-slate-800">Clans / Lineages</div>
                <p class="mt-1 text-sm text-slate-600">Manage clans linked to ethnic groups.</p>
            </a>

            <a href="{{ route('admin.users.index') }}" class="block rounded-2xl border border-slate-100 bg-white p-6 hover:shadow-card focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60">
                <div class="text-sm uppercase tracking-widest text-slate-400">Access</div>
                <div class="mt-1 text-lg font-semibold text-slate-800">Users</div>
                <p class="mt-1 text-sm text-slate-600">View users and manage their roles.</p>
            </a>

            <a href="{{ route('families.index') }}" class="block rounded-2xl border border-slate-100 bg-white p-6 hover:shadow-card focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60">
                <div class="text-sm uppercase tracking-widest text-slate-400">Directory</div>
                <div class="mt-1 text-lg font-semibold text-slate-800">Families</div>
                <p class="mt-1 text-sm text-slate-600">Browse and manage family spaces.</p>
            </a>

            <a href="{{ route('subscriptions') }}" class="block rounded-2xl border border-slate-100 bg-white p-6 hover:shadow-card focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60">
                <div class="text-sm uppercase tracking-widest text-slate-400">Billing</div>
                <div class="mt-1 text-lg font-semibold text-slate-800">Subscriptions</div>
                <p class="mt-1 text-sm text-slate-600">Plans and subscription overview.</p>
            </a>

            <a href="{{ route('admin.analytics.index') }}" class="block rounded-2xl border border-slate-100 bg-white p-6 hover:shadow-card focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-primary/60">
                <div class="text-sm uppercase tracking-widest text-slate-400">Insights</div>
                <div class="mt-1 text-lg font-semibold text-slate-800">Analytics</div>
                <p class="mt-1 text-sm text-slate-600">Engagement and growth metrics.</p>
            </a>
        </div>
    </section>
@endsection

@push('head')
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@24,400,0,0" />
@endpush
