# Premium Subscriptions MVP

## Goals
- Introduce paid tiers unlocking higher family-tree limits, storage, and AI storytelling features.
- Provide secure recurring billing with upgrade/downgrade flows and proration ready.
- Maintain auditability of subscription state for web and mobile clients.

## Domain Model

| Entity | Responsibilities | Key Fields |
| --- | --- | --- |
| `plans` | Define purchasable tiers | `code`, `name`, `price_cents`, `interval`, `features`, `is_active` |
| `subscriptions` | Track a family account (or user) subscription | `id`, `subscriber_type` (family/user), `subscriber_id`, `plan_id`, `status`, `renews_at`, `ends_at`, `meta` |
| `subscription_invoices` | Record billing events | `id`, `subscription_id`, `provider_invoice_id`, `amount_cents`, `currency`, `status`, `paid_at`, `meta` |
| `subscription_payment_methods` | Store provider tokens | `id`, `subscriber_type`, `subscriber_id`, `provider`, `reference`, `last4`, `brand`, `expires_at`, `is_default` |

### Relationships
- A Family (or User) **has one** active subscription at a time.
- A subscription **belongs to** a plan.
- Invoices **belong to** a subscription.
- Payment methods **morph to** family/user to accommodate family-wide billing or individual billing.

## API Endpoints (Draft)

| Method | Route | Description | Auth | Permissions |
| --- | --- | --- | --- | --- |
| `GET` | `/plans` | List active plans for display | Public | — |
| `POST` | `/plans` | Create/update plans (admin only) | Admin | `commerce.manage` |
| `POST` | `/subscriptions/preview` | Calculate pricing for plan change | Auth | `subscriptions.manage` |
| `POST` | `/subscriptions` | Create new subscription for family | Auth | `subscriptions.manage` |
| `PATCH` | `/subscriptions/{id}` | Upgrade/downgrade/cancel | Auth | `subscriptions.manage` |
| `POST` | `/subscriptions/{id}/resume` | Resume cancelled subscription | Auth | `subscriptions.manage` |
| `GET` | `/subscriptions/{id}/invoices` | List invoices | Auth | `subscriptions.view` |
| `POST` | `/subscriptions/{id}/payment-method` | Attach payment method token | Auth | `subscriptions.manage` |

> `subscriptions.manage` and `subscriptions.view` permissions should be granted to `admin` and optionally `hr-head` roles.

## Payment Provider Abstraction

Create a `BillingProviderInterface` with methods:
- `createCustomer(array $payload): BillingCustomer`
- `createSubscription(BillingCustomer $customer, Plan $plan, array $options): BillingSubscription`
- `swapSubscription(BillingSubscription $subscription, Plan $plan, array $options): BillingSubscription`
- `cancelSubscription(BillingSubscription $subscription, bool $immediate = false): void`
- `createPaymentMethod(array $payload): BillingPaymentMethod`
- `attachPaymentMethod(BillingCustomer $customer, BillingPaymentMethod $method): void`

Implementations:
- `StripeBillingProvider`
- `PaystackBillingProvider` (regional focus)

Provider choice stored in config (`config/billing.php`) with fallback to environment variable `BILLING_DRIVER`.

## Background Jobs & Webhooks
- Queue jobs for payment retries, invoice generation, and subscription renewals.
- Expose webhook endpoint `/billing/webhook/{provider}` to handle subscription lifecycle events (invoice paid, payment failed, subscription cancelled).
- Persist raw webhook payloads for audit + replay.

## Feature Flags & Enforcement
- Decorate feature checks with `SubscriptionFeatureService` to verify entitlement (e.g., `featureEnabled($family, 'ai_historian')`).
- Cache entitlements in Redis with invalidation on subscription changes.

## Migration Outline
1. `plans` table seeded with Free, Standard, Premium tiers.
2. `subscriptions` table referencing `plans` & morphs to family/user.
3. `subscription_invoices` and `subscription_payment_methods` tables for auditability.

## Client Considerations
- Mobile apps require subscription status in `/auth/me` payload.
- Provide upcoming invoice data for upgrade flows.
- Support grace periods and refund policy messaging.

## Next Steps
1. Draft migrations & Eloquent models.
2. Implement provider abstraction (start with Stripe test mode).
3. Build subscription controller + policy enforcement.
4. Wire webhooks + background commands for reconciliation.
5. Add integration tests covering upgrade/downgrade and failure paths.
