<?php

namespace Database\Factories;

use App\Models\Person;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<Person>
 */
class PersonFactory extends Factory
{
    protected $model = Person::class;

    public function definition(): array
    {
        return [
            'user_id' => null,
            'first_name' => $this->faker->firstName,
            'last_name' => $this->faker->lastName,
            'middle_name' => $this->faker->optional()->firstName,
            'gender' => $this->faker->randomElement(['male', 'female', 'other']),
            'birth_date' => $this->faker->optional()->date(),
            'death_date' => null,
            'place_of_birth' => $this->faker->optional()->city,
            'bio' => $this->faker->optional()->paragraph,
            'photo_url' => $this->faker->optional()->imageUrl,
            'meta' => [],
            'is_memorialized' => false,
            'memorialized_at' => null,
            'memorialized_by' => null,
            'memorial_note' => null,
        ];
    }

    public function withUser(): self
    {
        return $this->state(fn () => [
            'user_id' => User::factory(),
        ]);
    }
}
