<?php

namespace App\Services;

use App\Models\Family;
use App\Models\Relationship;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;

class RelationshipService
{
    public function listForFamily(Family $family, int $perPage = 15): LengthAwarePaginator
    {
        return $family->relationships()
            ->with(['person', 'relatedPerson'])
            ->latest('relationships.created_at')
            ->paginate($perPage);
    }

    public function create(Family $family, array $data): Relationship
    {
        return $family->relationships()->create($data);
    }

    public function update(Relationship $relationship, array $data): Relationship
    {
        $relationship->update($data);

        return $relationship->fresh(['person', 'relatedPerson']);
    }

    public function delete(Relationship $relationship): void
    {
        $relationship->delete();
    }
}
