<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class NotificationRelayService
{
    public function sendSms(?string $phone, string $message): void
    {
        if (!$phone) return;
        $endpoint = (string) config('services.sms_webhook.url', env('SMS_WEBHOOK_URL'));
        if (!$endpoint) return;
        try {
            Http::timeout(5)->asJson()->post($endpoint, [
                'to' => $phone,
                'message' => $message,
                'provider' => 'generic-webhook'
            ]);
        } catch (\Throwable $e) {
            // swallow silently
        }
    }

    public function sendWhatsApp(?string $phone, string $message): void
    {
        if (!$phone) return;
        $endpoint = (string) config('services.whatsapp_webhook.url', env('WHATSAPP_WEBHOOK_URL'));
        if (!$endpoint) return;
        try {
            Http::timeout(5)->asJson()->post($endpoint, [
                'to' => $phone,
                'message' => $message,
                'provider' => 'generic-webhook'
            ]);
        } catch (\Throwable $e) {
            // swallow silently
        }
    }
}
