<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton(\App\Services\Billing\BillingManager::class, function ($app) {
            return new \App\Services\Billing\BillingManager($app);
        });

        $this->app->bind(\App\Contracts\Billing\BillingProvider::class, function ($app) {
            return $app->make(\App\Services\Billing\BillingManager::class)->driver();
        });

        $this->app->singleton(\App\Integrations\Notification\NotificationGateway::class, function ($app) {
            return new \App\Integrations\Notification\NotificationGateway($app);
        });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}
