<?php

namespace App\Notifications;

use App\Models\FamilyWallPost;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class UserMentionedInPost extends Notification
{
    use Queueable;

    public function __construct(public FamilyWallPost $post)
    {
    }

    public function via(object $notifiable): array
    {
        return ['database'];
    }

    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'mention',
            'post_id' => $this->post->id,
            'family_id' => $this->post->family_id,
            'author_id' => $this->post->author_id,
            'message' => 'You were mentioned in a post.',
            'content_preview' => substr($this->post->content ?? '', 0, 140),
        ];
    }
}
