<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{
    use HasFactory;

    protected $fillable = [
        'plan_id',
        'subscriber_type',
        'subscriber_id',
        'status',
        'renews_at',
        'ends_at',
        'trial_ends_at',
        'meta',
        'provider',
        'provider_subscription_id',
    ];

    protected $casts = [
        'renews_at' => 'datetime',
        'ends_at' => 'datetime',
        'trial_ends_at' => 'datetime',
        'meta' => 'array',
    ];

    public function plan()
    {
        return $this->belongsTo(Plan::class);
    }

    public function subscriber()
    {
        return $this->morphTo();
    }

    public function invoices()
    {
        return $this->hasMany(SubscriptionInvoice::class);
    }
}
