<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Person extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'first_name',
        'last_name',
        'middle_name',
        'gender',
        'birth_date',
        'death_date',
        'place_of_birth',
        'bio',
        'photo_url',
        'meta',
        'is_memorialized',
        'memorialized_at',
        'memorialized_by',
        'memorial_note',
    ];

    protected $casts = [
        'birth_date' => 'date',
        'death_date' => 'date',
        'meta' => 'array',
        'is_memorialized' => 'boolean',
        'memorialized_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function families()
    {
        return $this->belongsToMany(Family::class, 'family_members')
            ->withPivot(['role', 'joined_at'])
            ->withTimestamps();
    }

    public function memorializedBy()
    {
        return $this->belongsTo(User::class, 'memorialized_by');
    }
}
