<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EthnicGroup extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'country_code',
        'languages',
        'description',
    ];

    public function clans()
    {
        return $this->hasMany(Clan::class);
    }

    public function families()
    {
        return $this->hasMany(Family::class);
    }

    public function clansMany()
    {
        return $this->belongsToMany(Clan::class, 'clan_ethnic_group');
    }
}
