<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Redirect;
use Spatie\Permission\Models\Role;

class UsersController extends Controller
{
    public function index(Request $request)
    {
        $query = User::query()->with('roles');

        if ($s = trim((string) $request->get('search'))) {
            $query->where(function ($q) use ($s) {
                $q->where('name', 'like', "%{$s}%")
                  ->orWhere('email', 'like', "%{$s}%");
            });
        }

        $users = $query->orderBy('name')->paginate(20)->withQueryString();
        $roles = Role::orderBy('name')->pluck('name');

        return view('admin.users.index', [
            'users' => $users,
            'roles' => $roles,
            'search' => $request->get('search'),
        ]);
    }

    public function updateRoles(Request $request, User $user)
    {
        $available = Role::pluck('name')->all();
        $data = $request->validate([
            'roles' => ['array'],
            'roles.*' => ['string'],
        ]);

        $roles = array_values(array_intersect($available, Arr::get($data, 'roles', [])));
        $user->syncRoles($roles);

        return Redirect::back()->with('status', 'Roles updated for '.$user->name);
    }
}
